<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Masra Sortant Controller
*| --------------------------------------------------------------------------
*| Agritun Masra Sortant site
*|
*/
class Agritun_masra_sortant extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_masra_sortant');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Masra Sortants
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_masra_sortant_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_masra_sortants'] = $this->model_agritun_masra_sortant->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_masra_sortant_counts'] = $this->model_agritun_masra_sortant->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_masra_sortant/index/',
			'total_rows'   => $this->data['agritun_masra_sortant_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('عمليات عصر الزيتون List');
		$this->render('backend/standart/administrator/agritun_masra_sortant/agritun_masra_sortant_list', $this->data);
	}
	
	/**
	* Add new agritun_masra_sortants
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_masra_sortant_add');

		$this->template->title('عمليات عصر الزيتون New');
		$this->render('backend/standart/administrator/agritun_masra_sortant/agritun_masra_sortant_add', $this->data);
	}

	/**
	* Add New Agritun Masra Sortants
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_masra_sortant_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('masra', 'المعصرة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite_zit', 'نوع الزيتون', 'trim|required');
		

		$this->form_validation->set_rules('qte_zitoun', 'كمية الزيتون', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('prix_u', 'سعر العصر', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte_zit', 'كمية  الزيت', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('cout', 'التكلفة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite', 'جودة الزيت', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'masra' => $this->input->post('masra'),
				'qualite_zit' => $this->input->post('qualite_zit'),
				'qte_zitoun' => $this->input->post('qte_zitoun'),
				'prix_u' => $this->input->post('prix_u'),
				'qte_zit' => $this->input->post('qte_zit'),
				'cout' => $this->input->post('cout'),
				'qualite' => $this->input->post('qualite'),
				'i_src' => $this->input->post('i_src'),
			];

			
			
			$save_agritun_masra_sortant = $this->model_agritun_masra_sortant->store($save_data);
            

			if ($save_agritun_masra_sortant) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_masra_sortant;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_masra_sortant/edit/' . $save_agritun_masra_sortant, 'Edit Agritun Masra Sortant'),
						anchor('administrator/agritun_masra_sortant', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_masra_sortant/edit/' . $save_agritun_masra_sortant, 'Edit Agritun Masra Sortant')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra_sortant');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra_sortant');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Masra Sortants
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_masra_sortant_update');

		$this->data['agritun_masra_sortant'] = $this->model_agritun_masra_sortant->find($id);

		$this->template->title('عمليات عصر الزيتون Update');
		$this->render('backend/standart/administrator/agritun_masra_sortant/agritun_masra_sortant_update', $this->data);
	}

	/**
	* Update Agritun Masra Sortants
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_masra_sortant_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('masra', 'المعصرة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite_zit', 'نوع الزيتون', 'trim|required');
		

		$this->form_validation->set_rules('qte_zitoun', 'كمية الزيتون', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('prix_u', 'سعر العصر', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte_zit', 'كمية  الزيت', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('cout', 'التكلفة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite', 'جودة الزيت', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'masra' => $this->input->post('masra'),
				'qualite_zit' => $this->input->post('qualite_zit'),
				'qte_zitoun' => $this->input->post('qte_zitoun'),
				'prix_u' => $this->input->post('prix_u'),
				'qte_zit' => $this->input->post('qte_zit'),
				'cout' => $this->input->post('cout'),
				'qualite' => $this->input->post('qualite'),
				'i_src' => $this->input->post('i_src'),
			];


			
			
			$save_agritun_masra_sortant = $this->model_agritun_masra_sortant->change($id, $save_data);

			if ($save_agritun_masra_sortant) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_masra_sortant', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra_sortant');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra_sortant');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Masra Sortants
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_masra_sortant_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_masra_sortant'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_masra_sortant'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Masra Sortants
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_masra_sortant_view');

		$this->data['agritun_masra_sortant'] = $this->model_agritun_masra_sortant->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('عمليات عصر الزيتون Detail');
		$this->render('backend/standart/administrator/agritun_masra_sortant/agritun_masra_sortant_view', $this->data);
	}
	
	/**
	* delete Agritun Masra Sortants
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_masra_sortant = $this->model_agritun_masra_sortant->find($id);

		
		
		return $this->model_agritun_masra_sortant->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_masra_sortant_export');

		$this->model_agritun_masra_sortant->export(
			'agritun_masra_sortant', 
			'agritun_masra_sortant',
			$this->model_agritun_masra_sortant->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_masra_sortant_export');

		$this->model_agritun_masra_sortant->pdf('agritun_masra_sortant', 'agritun_masra_sortant');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_masra_sortant_export');

		$table = $title = 'agritun_masra_sortant';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_masra_sortant->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_masra_sortant.php */
/* Location: ./application/controllers/administrator/Agritun Masra Sortant.php */