<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_paiement extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_paiement');
	}

	/**
	 * @api {get} /agritun_paiement/all Get all agritun_paiements.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunpaiement 
	 * @apiGroup agritun_paiement
	 * @apiHeader {String} X-Api-Key Agritun paiements unique access-key.
	 * @apiHeader {String} X-Token Agritun paiements unique token.
	 * @apiPermission Agritun paiement Cant be Accessed permission name : api_agritun_paiement_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun paiements.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun paiements : id, service, beneficiaire, montant, date, user_id, i_src, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun paiements.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun paiements.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_paiement.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun paiement Agritun paiement data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_paiement_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'service', 'beneficiaire', 'montant', 'date', 'user_id', 'i_src', 'id_parcel'];
		$agritun_paiements = $this->model_api_agritun_paiement->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_paiement->count_all($filter, $field);
		$agritun_paiements = array_map(function($row){
						
			return $row;
		}, $agritun_paiements);

		$data['agritun_paiement'] = $agritun_paiements;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun paiement',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_paiement/detail Detail Agritun paiement.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun paiement
	 * @apiGroup agritun_paiement
	 * @apiHeader {String} X-Api-Key Agritun paiements unique access-key.
	 * @apiHeader {String} X-Token Agritun paiements unique token.
	 * @apiPermission Agritun paiement Cant be Accessed permission name : api_agritun_paiement_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun paiements.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_paiement.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun paiementNotFound Agritun paiement data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_paiement_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'service', 'beneficiaire', 'montant', 'date', 'user_id', 'i_src', 'id_parcel'];
		$agritun_paiement = $this->model_api_agritun_paiement->find($id, $select_field);

		if (!$agritun_paiement) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_paiement'] = $agritun_paiement;
		if ($data['agritun_paiement']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun paiement',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun paiement not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_paiement/add Add Agritun paiement.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun paiement
	 * @apiGroup agritun_paiement
	 * @apiHeader {String} X-Api-Key Agritun paiements unique access-key.
	 * @apiHeader {String} X-Token Agritun paiements unique token.
	 * @apiPermission Agritun paiement Cant be Accessed permission name : api_agritun_paiement_add
	 *
 	 * @apiParam {String} Service Mandatory service of Agritun paiements. Input Service Max Length : 300. 
	 * @apiParam {String} Beneficiaire Mandatory beneficiaire of Agritun paiements. Input Beneficiaire Max Length : 300. 
	 * @apiParam {String} Montant Mandatory montant of Agritun paiements. Input Montant Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun paiements. Input User Id Max Length : 300. 
	 * @apiParam {String} [I_src] Optional i_src of Agritun paiements. Input I Src Max Length : 500. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun paiements. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_paiement_add');

		$this->form_validation->set_rules('service', 'Service', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('beneficiaire', 'Beneficiaire', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('montant', 'Montant', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|max_length[500]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'service' => $this->input->post('service'),
				'beneficiaire' => $this->input->post('beneficiaire'),
				'montant' => $this->input->post('montant'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_paiement = $this->model_api_agritun_paiement->store($save_data);

			if ($save_agritun_paiement) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_paiement/update Update Agritun paiement.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun paiement
	 * @apiGroup agritun_paiement
	 * @apiHeader {String} X-Api-Key Agritun paiements unique access-key.
	 * @apiHeader {String} X-Token Agritun paiements unique token.
	 * @apiPermission Agritun paiement Cant be Accessed permission name : api_agritun_paiement_update
	 *
	 * @apiParam {String} Service Mandatory service of Agritun paiements. Input Service Max Length : 300. 
	 * @apiParam {String} Beneficiaire Mandatory beneficiaire of Agritun paiements. Input Beneficiaire Max Length : 300. 
	 * @apiParam {String} Montant Mandatory montant of Agritun paiements. Input Montant Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun paiements. Input User Id Max Length : 300. 
	 * @apiParam {String} [I_src] Optional i_src of Agritun paiements. Input I Src Max Length : 500. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun paiements. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Paiement.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_paiement_update');

		
		$this->form_validation->set_rules('service', 'Service', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('beneficiaire', 'Beneficiaire', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('montant', 'Montant', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|max_length[500]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'service' => $this->input->post('service'),
				'beneficiaire' => $this->input->post('beneficiaire'),
				'montant' => $this->input->post('montant'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_paiement = $this->model_api_agritun_paiement->change($this->post('id'), $save_data);

			if ($save_agritun_paiement) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_paiement/delete Delete Agritun paiement. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun paiement
	 * @apiGroup agritun_paiement
	 * @apiHeader {String} X-Api-Key Agritun paiements unique access-key.
	 * @apiHeader {String} X-Token Agritun paiements unique token.
	 	 * @apiPermission Agritun paiement Cant be Accessed permission name : api_agritun_paiement_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun paiements .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_paiement_delete');

		$agritun_paiement = $this->model_api_agritun_paiement->find($this->post('id'));

		if (!$agritun_paiement) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun paiement not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_paiement->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun paiement deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun paiement not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun paiement.php */
/* Location: ./application/controllers/api/Agritun paiement.php */