<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_recolte extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_recolte');
	}

	/**
	 * @api {get} /agritun_recolte/all Get all agritun_recoltes.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunrecolte 
	 * @apiGroup agritun_recolte
	 * @apiHeader {String} X-Api-Key Agritun recoltes unique access-key.
	 * @apiHeader {String} X-Token Agritun recoltes unique token.
	 * @apiPermission Agritun recolte Cant be Accessed permission name : api_agritun_recolte_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun recoltes.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun recoltes : id, date, id_parcel, id_equipe, id_utilisateur, mode_paiement, nbr_pieds, hay, nchira, q_unite, q_prix, h_prix, f_prix, h_nbr, f_nbr, cout, i_src, user_id.
	 * @apiParam {String} [Start=0] Optional start index of Agritun recoltes.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun recoltes.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_recolte.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun recolte Agritun recolte data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_recolte_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'date', 'id_parcel', 'id_equipe', 'id_utilisateur', 'mode_paiement', 'nbr_pieds', 'hay', 'nchira', 'q_unite', 'q_prix', 'h_prix', 'f_prix', 'h_nbr', 'f_nbr', 'cout', 'i_src', 'user_id'];
		$agritun_recoltes = $this->model_api_agritun_recolte->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_recolte->count_all($filter, $field);
		$agritun_recoltes = array_map(function($row){
			
			
			return $row;
		}, $agritun_recoltes);

		$data['agritun_recolte'] = $agritun_recoltes;
		
		
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun recolte',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

	
	/**
	 * @api {get} /agritun_recolte/detail Detail Agritun recolte.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun recolte
	 * @apiGroup agritun_recolte
	 * @apiHeader {String} X-Api-Key Agritun recoltes unique access-key.
	 * @apiHeader {String} X-Token Agritun recoltes unique token.
	 * @apiPermission Agritun recolte Cant be Accessed permission name : api_agritun_recolte_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun recoltes.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_recolte.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun recolteNotFound Agritun recolte data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_recolte_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'date', 'id_parcel', 'id_equipe', 'id_utilisateur', 'mode_paiement', 'nbr_pieds', 'hay', 'nchira', 'q_unite', 'q_prix', 'h_prix', 'f_prix', 'h_nbr', 'f_nbr', 'cout', 'i_src', 'user_id'];
		$agritun_recolte = $this->model_api_agritun_recolte->find($id, $select_field);

		if (!$agritun_recolte) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

		
			
		$data['agritun_recolte'] = $agritun_recolte;
		if ($data['agritun_recolte']) {
			

			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun recolte',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun recolte not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_recolte/add Add Agritun recolte.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun recolte
	 * @apiGroup agritun_recolte
	 * @apiHeader {String} X-Api-Key Agritun recoltes unique access-key.
	 * @apiHeader {String} X-Token Agritun recoltes unique token.
	 * @apiPermission Agritun recolte Cant be Accessed permission name : api_agritun_recolte_add
	 *
 	 * @apiParam {String} Id_parcel Mandatory id_parcel of Agritun recoltes. Input Id Parcel Max Length : 100. 
	 * @apiParam {String} Id_equipe Mandatory id_equipe of Agritun recoltes. Input Id Equipe Max Length : 100. 
	 * @apiParam {String} Id_utilisateur Mandatory id_utilisateur of Agritun recoltes. Input Id Utilisateur Max Length : 11. 
	 * @apiParam {String} Mode_paiement Mandatory mode_paiement of Agritun recoltes. Input Mode Paiement Max Length : 300. 
	 * @apiParam {String} Nbr_pieds Mandatory nbr_pieds of Agritun recoltes. Input Nbr Pieds Max Length : 100. 
	 * @apiParam {String} Hay Mandatory hay of Agritun recoltes. Input Hay Max Length : 100. 
	 * @apiParam {String} Nchira Mandatory nchira of Agritun recoltes. Input Nchira Max Length : 100. 
	 * @apiParam {String} [Q_unite] Optional q_unite of Agritun recoltes. Input Q Unite Max Length : 300. 
	 * @apiParam {String} [Q_prix] Optional q_prix of Agritun recoltes. Input Q Prix Max Length : 300. 
	 * @apiParam {String} [H_prix] Optional h_prix of Agritun recoltes. Input H Prix Max Length : 300. 
	 * @apiParam {String} [F_prix] Optional f_prix of Agritun recoltes. Input F Prix Max Length : 300. 
	 * @apiParam {String} [H_nbr] Optional h_nbr of Agritun recoltes. Input H Nbr Max Length : 300. 
	 * @apiParam {String} [F_nbr] Optional f_nbr of Agritun recoltes. Input F Nbr Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun recoltes.  
	 * @apiParam {String} I_src Mandatory i_src of Agritun recoltes. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun recoltes. Input User Id Max Length : 11. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_recolte_add');

		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('id_equipe', 'Id Equipe', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('id_utilisateur', 'Id Utilisateur', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_paiement', 'Mode Paiement', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('hay', 'Hay', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('nchira', 'Nchira', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('q_unite', 'Q Unite', 'trim|max_length[300]');
		$this->form_validation->set_rules('q_prix', 'Q Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_prix', 'H Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_prix', 'F Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_nbr', 'H Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_nbr', 'F Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'id_parcel' => $this->input->post('id_parcel'),

			
	'id_equipe' => $this->input->post('id_equipe'),

			
	'id_utilisateur' => $this->input->post('id_utilisateur'),

			
	'mode_paiement' => $this->input->post('mode_paiement'),

			
	'nbr_pieds' => $this->input->post('nbr_pieds'),

			
	'hay' => $this->input->post('hay'),

			
	'nchira' => $this->input->post('nchira'),

			
	'q_unite' => $this->input->post('q_unite'),

			
	'q_prix' => $this->input->post('q_prix'),

			
	'h_prix' => $this->input->post('h_prix'),

			
	'f_prix' => $this->input->post('f_prix'),

			
	'h_nbr' => $this->input->post('h_nbr'),

			
	'f_nbr' => $this->input->post('f_nbr'),

			
	'cout' => $this->input->post('cout'),

			
	'i_src' => $this->input->post('i_src'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_recolte = $this->model_api_agritun_recolte->store($save_data);

			if ($save_agritun_recolte) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_recolte/update Update Agritun recolte.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun recolte
	 * @apiGroup agritun_recolte
	 * @apiHeader {String} X-Api-Key Agritun recoltes unique access-key.
	 * @apiHeader {String} X-Token Agritun recoltes unique token.
	 * @apiPermission Agritun recolte Cant be Accessed permission name : api_agritun_recolte_update
	 *
	 * @apiParam {String} Id_parcel Mandatory id_parcel of Agritun recoltes. Input Id Parcel Max Length : 100. 
	 * @apiParam {String} Id_equipe Mandatory id_equipe of Agritun recoltes. Input Id Equipe Max Length : 100. 
	 * @apiParam {String} Id_utilisateur Mandatory id_utilisateur of Agritun recoltes. Input Id Utilisateur Max Length : 11. 
	 * @apiParam {String} Mode_paiement Mandatory mode_paiement of Agritun recoltes. Input Mode Paiement Max Length : 300. 
	 * @apiParam {String} Nbr_pieds Mandatory nbr_pieds of Agritun recoltes. Input Nbr Pieds Max Length : 100. 
	 * @apiParam {String} Hay Mandatory hay of Agritun recoltes. Input Hay Max Length : 100. 
	 * @apiParam {String} Nchira Mandatory nchira of Agritun recoltes. Input Nchira Max Length : 100. 
	 * @apiParam {String} [Q_unite] Optional q_unite of Agritun recoltes. Input Q Unite Max Length : 300. 
	 * @apiParam {String} [Q_prix] Optional q_prix of Agritun recoltes. Input Q Prix Max Length : 300. 
	 * @apiParam {String} [H_prix] Optional h_prix of Agritun recoltes. Input H Prix Max Length : 300. 
	 * @apiParam {String} [F_prix] Optional f_prix of Agritun recoltes. Input F Prix Max Length : 300. 
	 * @apiParam {String} [H_nbr] Optional h_nbr of Agritun recoltes. Input H Nbr Max Length : 300. 
	 * @apiParam {String} [F_nbr] Optional f_nbr of Agritun recoltes. Input F Nbr Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun recoltes.  
	 * @apiParam {String} I_src Mandatory i_src of Agritun recoltes. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun recoltes. Input User Id Max Length : 11. 
	 * @apiParam {Integer} id Mandatory id of Agritun Recolte.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_recolte_update');

		
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('id_equipe', 'Id Equipe', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('id_utilisateur', 'Id Utilisateur', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_paiement', 'Mode Paiement', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('hay', 'Hay', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('nchira', 'Nchira', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('q_unite', 'Q Unite', 'trim|max_length[300]');
		$this->form_validation->set_rules('q_prix', 'Q Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_prix', 'H Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_prix', 'F Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_nbr', 'H Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_nbr', 'F Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'id_parcel' => $this->input->post('id_parcel'),

			
	'id_equipe' => $this->input->post('id_equipe'),

			
	'id_utilisateur' => $this->input->post('id_utilisateur'),

			
	'mode_paiement' => $this->input->post('mode_paiement'),

			
	'nbr_pieds' => $this->input->post('nbr_pieds'),

			
	'hay' => $this->input->post('hay'),

			
	'nchira' => $this->input->post('nchira'),

			
	'q_unite' => $this->input->post('q_unite'),

			
	'q_prix' => $this->input->post('q_prix'),

			
	'h_prix' => $this->input->post('h_prix'),

			
	'f_prix' => $this->input->post('f_prix'),

			
	'h_nbr' => $this->input->post('h_nbr'),

			
	'f_nbr' => $this->input->post('f_nbr'),

			
	'cout' => $this->input->post('cout'),

			
	'i_src' => $this->input->post('i_src'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_recolte = $this->model_api_agritun_recolte->change($this->post('id'), $save_data);

			if ($save_agritun_recolte) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_recolte/delete Delete Agritun recolte. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun recolte
	 * @apiGroup agritun_recolte
	 * @apiHeader {String} X-Api-Key Agritun recoltes unique access-key.
	 * @apiHeader {String} X-Token Agritun recoltes unique token.
	 
	 * @apiPermission Agritun recolte Cant be Accessed permission name : api_agritun_recolte_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun recoltes .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_recolte_delete');

		$agritun_recolte = $this->model_api_agritun_recolte->find($this->post('id'));

		if (!$agritun_recolte) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun recolte not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_recolte->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun recolte deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun recolte not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	

}

/* End of file Agritun recolte.php */
/* Location: ./application/controllers/api/Agritun recolte.php */