<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Recolte Controller
*| --------------------------------------------------------------------------
*| Agritun Recolte site
*|
*/
class Agritun_recolte extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_recolte');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Recoltes
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_recolte_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_recoltes'] = $this->model_agritun_recolte->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_recolte_counts'] = $this->model_agritun_recolte->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_recolte/index/',
			'total_rows'   => $this->data['agritun_recolte_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Agritun Recolte List');
		$this->render('backend/standart/administrator/agritun_recolte/agritun_recolte_list', $this->data);
	}
	
	/**
	* Add new agritun_recoltes
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_recolte_add');

		$this->template->title('Agritun Recolte New');
		$this->render('backend/standart/administrator/agritun_recolte/agritun_recolte_add', $this->data);
	}

	/**
	* Add New Agritun Recoltes
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_recolte_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('id_parcel', 'قطعة الأرض', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('id_equipe', 'الجماعة', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('mode_paiement', 'طريقة الخلاص', 'trim|required');
		

		$this->form_validation->set_rules('nbr_pieds', 'عدد الأشجار', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('hay', 'حي', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('nchira', 'نشيرة', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('q_unite', 'وحدة القيس', 'trim|required');
		

		$this->form_validation->set_rules('q_prix', 'سعر الوحدة', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('h_prix', 'أجرة الرجل', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('f_prix', 'أجرة المرأة', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('h_nbr', 'عدد الرجال', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('f_nbr', 'عدد النساء', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('cout', 'التكلفة', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'id_parcel' => $this->input->post('id_parcel'),
				'id_equipe' => $this->input->post('id_equipe'),
				'mode_paiement' => $this->input->post('mode_paiement'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'hay' => $this->input->post('hay'),
				'nchira' => $this->input->post('nchira'),
				'q_unite' => $this->input->post('q_unite'),
				'q_prix' => $this->input->post('q_prix'),
				'h_prix' => $this->input->post('h_prix'),
				'f_prix' => $this->input->post('f_prix'),
				'h_nbr' => $this->input->post('h_nbr'),
				'f_nbr' => $this->input->post('f_nbr'),
				'cout' => $this->input->post('cout'),
				'i_src' => $this->input->post('i_src'),
			];

			
			
			$save_agritun_recolte = $this->model_agritun_recolte->store($save_data);
            

			if ($save_agritun_recolte) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_recolte;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_recolte/edit/' . $save_agritun_recolte, 'Edit Agritun Recolte'),
						anchor('administrator/agritun_recolte', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_recolte/edit/' . $save_agritun_recolte, 'Edit Agritun Recolte')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_recolte');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_recolte');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Recoltes
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_recolte_update');

		$this->data['agritun_recolte'] = $this->model_agritun_recolte->find($id);

		$this->template->title('Agritun Recolte Update');
		$this->render('backend/standart/administrator/agritun_recolte/agritun_recolte_update', $this->data);
	}

	/**
	* Update Agritun Recoltes
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_recolte_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('id_parcel', 'قطعة الأرض', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('id_equipe', 'الجماعة', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('mode_paiement', 'طريقة الخلاص', 'trim|required');
		

		$this->form_validation->set_rules('nbr_pieds', 'عدد الأشجار', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('hay', 'حي', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('nchira', 'نشيرة', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('q_unite', 'وحدة القيس', 'trim|required');
		

		$this->form_validation->set_rules('q_prix', 'سعر الوحدة', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('h_prix', 'أجرة الرجل', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('f_prix', 'أجرة المرأة', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('h_nbr', 'عدد الرجال', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('f_nbr', 'عدد النساء', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('cout', 'التكلفة', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'id_parcel' => $this->input->post('id_parcel'),
				'id_equipe' => $this->input->post('id_equipe'),
				'mode_paiement' => $this->input->post('mode_paiement'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'hay' => $this->input->post('hay'),
				'nchira' => $this->input->post('nchira'),
				'q_unite' => $this->input->post('q_unite'),
				'q_prix' => $this->input->post('q_prix'),
				'h_prix' => $this->input->post('h_prix'),
				'f_prix' => $this->input->post('f_prix'),
				'h_nbr' => $this->input->post('h_nbr'),
				'f_nbr' => $this->input->post('f_nbr'),
				'cout' => $this->input->post('cout'),
				'i_src' => $this->input->post('i_src'),
			];


			
			
			$save_agritun_recolte = $this->model_agritun_recolte->change($id, $save_data);

			if ($save_agritun_recolte) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_recolte', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_recolte');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_recolte');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Recoltes
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_recolte_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_recolte'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_recolte'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Recoltes
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_recolte_view');

		$this->data['agritun_recolte'] = $this->model_agritun_recolte->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Agritun Recolte Detail');
		$this->render('backend/standart/administrator/agritun_recolte/agritun_recolte_view', $this->data);
	}
	
	/**
	* delete Agritun Recoltes
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_recolte = $this->model_agritun_recolte->find($id);

		
		
		return $this->model_agritun_recolte->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_recolte_export');

		$this->model_agritun_recolte->export(
			'agritun_recolte', 
			'agritun_recolte',
			$this->model_agritun_recolte->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_recolte_export');

		$this->model_agritun_recolte->pdf('agritun_recolte', 'agritun_recolte');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_recolte_export');

		$table = $title = 'agritun_recolte';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_recolte->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	public function ajax_mode_paiement($id = null)
	{
		if (!$this->is_allowed('agritun_recolte_list', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		$results = db_get_all_data('agritun_team', ['id' => $id]);
		$this->response($results);	
	}

	
}


/* End of file agritun_recolte.php */
/* Location: ./application/controllers/administrator/Agritun Recolte.php */