<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Team Controller
*| --------------------------------------------------------------------------
*| Agritun Team site
*|
*/
class Agritun_team extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_team');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Teams
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_team_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_teams'] = $this->model_agritun_team->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_team_counts'] = $this->model_agritun_team->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_team/index/',
			'total_rows'   => $this->data['agritun_team_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('الجماعة List');
		$this->render('backend/standart/administrator/agritun_team/agritun_team_list', $this->data);
	}
	
	/**
	* Add new agritun_teams
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_team_add');

		$this->template->title('الجماعة New');
		$this->render('backend/standart/administrator/agritun_team/agritun_team_add', $this->data);
	}

	/**
	* Add New Agritun Teams
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_team_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('team_name', 'اسم الجماعة', 'trim|required');
		

		$this->form_validation->set_rules('mode_paiement', 'طريقة الدفع', 'trim|required');
		

		$this->form_validation->set_rules('q_unite', 'وحدة الجمعان', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'team_name' => $this->input->post('team_name'),
				'mode_paiement' => $this->input->post('mode_paiement'),
				'h_prix' => $this->input->post('h_prix'),
				'f_prix' => $this->input->post('f_prix'),
				'h_nbr' => $this->input->post('h_nbr'),
				'f_nbr' => $this->input->post('f_nbr'),
				'q_unite' => $this->input->post('q_unite'),
				'q_prix' => $this->input->post('q_prix'),
				'mode_culture' => $this->input->post('mode_culture'),
				'tel' => $this->input->post('tel'),
			];

			
			
			$save_agritun_team = $this->model_agritun_team->store($save_data);
            

			if ($save_agritun_team) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_team;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_team/edit/' . $save_agritun_team, 'Edit Agritun Team'),
						anchor('administrator/agritun_team', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_team/edit/' . $save_agritun_team, 'Edit Agritun Team')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_team');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_team');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Teams
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_team_update');

		$this->data['agritun_team'] = $this->model_agritun_team->find($id);

		$this->template->title('الجماعة Update');
		$this->render('backend/standart/administrator/agritun_team/agritun_team_update', $this->data);
	}

	/**
	* Update Agritun Teams
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_team_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('team_name', 'اسم الجماعة', 'trim|required');
		

		$this->form_validation->set_rules('mode_paiement', 'طريقة الدفع', 'trim|required');
		

		$this->form_validation->set_rules('q_unite', 'وحدة الجمعان', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'team_name' => $this->input->post('team_name'),
				'mode_paiement' => $this->input->post('mode_paiement'),
				'h_prix' => $this->input->post('h_prix'),
				'f_prix' => $this->input->post('f_prix'),
				'h_nbr' => $this->input->post('h_nbr'),
				'f_nbr' => $this->input->post('f_nbr'),
				'q_unite' => $this->input->post('q_unite'),
				'q_prix' => $this->input->post('q_prix'),
				'mode_culture' => $this->input->post('mode_culture'),
				'tel' => $this->input->post('tel'),
			];


			
			
			$save_agritun_team = $this->model_agritun_team->change($id, $save_data);

			if ($save_agritun_team) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_team', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_team');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_team');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Teams
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_team_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_team'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_team'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Teams
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_team_view');

		$this->data['agritun_team'] = $this->model_agritun_team->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('الجماعة Detail');
		$this->render('backend/standart/administrator/agritun_team/agritun_team_view', $this->data);
	}
	
	/**
	* delete Agritun Teams
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_team = $this->model_agritun_team->find($id);

		
		
		return $this->model_agritun_team->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_team_export');

		$this->model_agritun_team->export(
			'agritun_team', 
			'agritun_team',
			$this->model_agritun_team->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_team_export');

		$this->model_agritun_team->pdf('agritun_team', 'agritun_team');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_team_export');

		$table = $title = 'agritun_team';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_team->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_team.php */
/* Location: ./application/controllers/administrator/Agritun Team.php */