<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_transport extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_transport');
	}

	/**
	 * @api {get} /agritun_transport/all Get all agritun_transports.
	 * @apiVersion 0.1.0
	 * @apiName AllAgrituntransport 
	 * @apiGroup agritun_transport
	 * @apiHeader {String} X-Api-Key Agritun transports unique access-key.
	 * @apiHeader {String} X-Token Agritun transports unique token.
	 * @apiPermission Agritun transport Cant be Accessed permission name : api_agritun_transport_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun transports.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun transports : id, id_transporteur, qte, qte_unite, cout, date, user_id, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun transports.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun transports.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_transport.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun transport Agritun transport data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_transport_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'id_transporteur', 'qte', 'qte_unite', 'cout', 'date', 'user_id', 'id_parcel'];
		$agritun_transports = $this->model_api_agritun_transport->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_transport->count_all($filter, $field);
		$agritun_transports = array_map(function($row){
						
			return $row;
		}, $agritun_transports);

		$data['agritun_transport'] = $agritun_transports;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun transport',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_transport/detail Detail Agritun transport.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun transport
	 * @apiGroup agritun_transport
	 * @apiHeader {String} X-Api-Key Agritun transports unique access-key.
	 * @apiHeader {String} X-Token Agritun transports unique token.
	 * @apiPermission Agritun transport Cant be Accessed permission name : api_agritun_transport_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun transports.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_transport.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun transportNotFound Agritun transport data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_transport_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'id_transporteur', 'qte', 'qte_unite', 'cout', 'date', 'user_id', 'id_parcel'];
		$agritun_transport = $this->model_api_agritun_transport->find($id, $select_field);

		if (!$agritun_transport) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_transport'] = $agritun_transport;
		if ($data['agritun_transport']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun transport',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transport not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_transport/add Add Agritun transport.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun transport
	 * @apiGroup agritun_transport
	 * @apiHeader {String} X-Api-Key Agritun transports unique access-key.
	 * @apiHeader {String} X-Token Agritun transports unique token.
	 * @apiPermission Agritun transport Cant be Accessed permission name : api_agritun_transport_add
	 *
 	 * @apiParam {String} Id_transporteur Mandatory id_transporteur of Agritun transports. Input Id Transporteur Max Length : 300. 
	 * @apiParam {String} Qte Mandatory qte of Agritun transports. Input Qte Max Length : 300. 
	 * @apiParam {String} Qte_unite Mandatory qte_unite of Agritun transports. Input Qte Unite Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun transports. Input Cout Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun transports. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun transports. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_transport_add');

		$this->form_validation->set_rules('id_transporteur', 'Id Transporteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte', 'Qte', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_unite', 'Qte Unite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'id_transporteur' => $this->input->post('id_transporteur'),
				'qte' => $this->input->post('qte'),
				'qte_unite' => $this->input->post('qte_unite'),
				'cout' => $this->input->post('cout'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_transport = $this->model_api_agritun_transport->store($save_data);

			if ($save_agritun_transport) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_transport/update Update Agritun transport.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun transport
	 * @apiGroup agritun_transport
	 * @apiHeader {String} X-Api-Key Agritun transports unique access-key.
	 * @apiHeader {String} X-Token Agritun transports unique token.
	 * @apiPermission Agritun transport Cant be Accessed permission name : api_agritun_transport_update
	 *
	 * @apiParam {String} Id_transporteur Mandatory id_transporteur of Agritun transports. Input Id Transporteur Max Length : 300. 
	 * @apiParam {String} Qte Mandatory qte of Agritun transports. Input Qte Max Length : 300. 
	 * @apiParam {String} Qte_unite Mandatory qte_unite of Agritun transports. Input Qte Unite Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun transports. Input Cout Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun transports. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun transports. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Transport.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_transport_update');

		
		$this->form_validation->set_rules('id_transporteur', 'Id Transporteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte', 'Qte', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_unite', 'Qte Unite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'id_transporteur' => $this->input->post('id_transporteur'),
				'qte' => $this->input->post('qte'),
				'qte_unite' => $this->input->post('qte_unite'),
				'cout' => $this->input->post('cout'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_transport = $this->model_api_agritun_transport->change($this->post('id'), $save_data);

			if ($save_agritun_transport) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_transport/delete Delete Agritun transport. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun transport
	 * @apiGroup agritun_transport
	 * @apiHeader {String} X-Api-Key Agritun transports unique access-key.
	 * @apiHeader {String} X-Token Agritun transports unique token.
	 	 * @apiPermission Agritun transport Cant be Accessed permission name : api_agritun_transport_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun transports .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_transport_delete');

		$agritun_transport = $this->model_api_agritun_transport->find($this->post('id'));

		if (!$agritun_transport) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transport not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_transport->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun transport deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transport not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun transport.php */
/* Location: ./application/controllers/api/Agritun transport.php */