<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_transporteurs extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_transporteurs');
	}

	/**
	 * @api {get} /agritun_transporteurs/all Get all agritun_transporteurss.
	 * @apiVersion 0.1.0
	 * @apiName AllAgrituntransporteurs 
	 * @apiGroup agritun_transporteurs
	 * @apiHeader {String} X-Api-Key Agritun transporteurss unique access-key.
	 * @apiHeader {String} X-Token Agritun transporteurss unique token.
	 * @apiPermission Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun transporteurss.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun transporteurss : id, type_transporteur, nom_chauffeur, matricule, tel, user_id.
	 * @apiParam {String} [Start=0] Optional start index of Agritun transporteurss.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun transporteurss.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_transporteurs.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun transporteurs Agritun transporteurs data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_transporteurs_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'type_transporteur', 'nom_chauffeur', 'matricule', 'tel', 'user_id'];
		$agritun_transporteurss = $this->model_api_agritun_transporteurs->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_transporteurs->count_all($filter, $field);
		$agritun_transporteurss = array_map(function($row){
			
			
			return $row;
		}, $agritun_transporteurss);

		$data['agritun_transporteurs'] = $agritun_transporteurss;
		
		
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun transporteurs',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

	
	/**
	 * @api {get} /agritun_transporteurs/detail Detail Agritun transporteurs.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun transporteurs
	 * @apiGroup agritun_transporteurs
	 * @apiHeader {String} X-Api-Key Agritun transporteurss unique access-key.
	 * @apiHeader {String} X-Token Agritun transporteurss unique token.
	 * @apiPermission Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun transporteurss.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_transporteurs.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun transporteursNotFound Agritun transporteurs data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_transporteurs_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'type_transporteur', 'nom_chauffeur', 'matricule', 'tel', 'user_id'];
		$agritun_transporteurs = $this->model_api_agritun_transporteurs->find($id, $select_field);

		if (!$agritun_transporteurs) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

		
			
		$data['agritun_transporteurs'] = $agritun_transporteurs;
		if ($data['agritun_transporteurs']) {
			

			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun transporteurs',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transporteurs not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_transporteurs/add Add Agritun transporteurs.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun transporteurs
	 * @apiGroup agritun_transporteurs
	 * @apiHeader {String} X-Api-Key Agritun transporteurss unique access-key.
	 * @apiHeader {String} X-Token Agritun transporteurss unique token.
	 * @apiPermission Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_add
	 *
 	 * @apiParam {String} Type_transporteur Mandatory type_transporteur of Agritun transporteurss. Input Type Transporteur Max Length : 300. 
	 * @apiParam {String} Nom_chauffeur Mandatory nom_chauffeur of Agritun transporteurss. Input Nom Chauffeur Max Length : 300. 
	 * @apiParam {String} [Matricule] Optional matricule of Agritun transporteurss. Input Matricule Max Length : 300. 
	 * @apiParam {String} [Tel] Optional tel of Agritun transporteurss. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun transporteurss. Input User Id Max Length : 11. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_transporteurs_add');

		$this->form_validation->set_rules('type_transporteur', 'Type Transporteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nom_chauffeur', 'Nom Chauffeur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('matricule', 'Matricule', 'trim|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'type_transporteur' => $this->input->post('type_transporteur'),

			
	'nom_chauffeur' => $this->input->post('nom_chauffeur'),

			
	'matricule' => $this->input->post('matricule'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_transporteurs = $this->model_api_agritun_transporteurs->store($save_data);

			if ($save_agritun_transporteurs) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_transporteurs/update Update Agritun transporteurs.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun transporteurs
	 * @apiGroup agritun_transporteurs
	 * @apiHeader {String} X-Api-Key Agritun transporteurss unique access-key.
	 * @apiHeader {String} X-Token Agritun transporteurss unique token.
	 * @apiPermission Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_update
	 *
	 * @apiParam {String} Type_transporteur Mandatory type_transporteur of Agritun transporteurss. Input Type Transporteur Max Length : 300. 
	 * @apiParam {String} Nom_chauffeur Mandatory nom_chauffeur of Agritun transporteurss. Input Nom Chauffeur Max Length : 300. 
	 * @apiParam {String} [Matricule] Optional matricule of Agritun transporteurss. Input Matricule Max Length : 300. 
	 * @apiParam {String} [Tel] Optional tel of Agritun transporteurss. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun transporteurss. Input User Id Max Length : 11. 
	 * @apiParam {Integer} id Mandatory id of Agritun Transporteurs.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_transporteurs_update');

		
		$this->form_validation->set_rules('type_transporteur', 'Type Transporteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nom_chauffeur', 'Nom Chauffeur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('matricule', 'Matricule', 'trim|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'type_transporteur' => $this->input->post('type_transporteur'),

			
	'nom_chauffeur' => $this->input->post('nom_chauffeur'),

			
	'matricule' => $this->input->post('matricule'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_transporteurs = $this->model_api_agritun_transporteurs->change($this->post('id'), $save_data);

			if ($save_agritun_transporteurs) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_transporteurs/delete Delete Agritun transporteurs. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun transporteurs
	 * @apiGroup agritun_transporteurs
	 * @apiHeader {String} X-Api-Key Agritun transporteurss unique access-key.
	 * @apiHeader {String} X-Token Agritun transporteurss unique token.
	 
	 * @apiPermission Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun transporteurss .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_transporteurs_delete');

		$agritun_transporteurs = $this->model_api_agritun_transporteurs->find($this->post('id'));

		if (!$agritun_transporteurs) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transporteurs not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_transporteurs->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun transporteurs deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun transporteurs not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	

}

/* End of file Agritun transporteurs.php */
/* Location: ./application/controllers/api/Agritun transporteurs.php */