<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Transporteurs Controller
*| --------------------------------------------------------------------------
*| Agritun Transporteurs site
*|
*/
class Agritun_transporteurs extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_transporteurs');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Transporteurss
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_transporteurs_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_transporteurss'] = $this->model_agritun_transporteurs->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_transporteurs_counts'] = $this->model_agritun_transporteurs->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_transporteurs/index/',
			'total_rows'   => $this->data['agritun_transporteurs_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Agritun Transporteurs List');
		$this->render('backend/standart/administrator/agritun_transporteurs/agritun_transporteurs_list', $this->data);
	}
	
	/**
	* Add new agritun_transporteurss
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_transporteurs_add');

		$this->template->title('Agritun Transporteurs New');
		$this->render('backend/standart/administrator/agritun_transporteurs/agritun_transporteurs_add', $this->data);
	}

	/**
	* Add New Agritun Transporteurss
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_transporteurs_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('type_transporteur', 'نوع النقل', 'trim|required');
		

		$this->form_validation->set_rules('nom_chauffeur', 'إسم السائق', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('matricule', 'اللوحة المنجمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('tel', 'رقم الهاتف', 'trim|required|max_length[300]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'type_transporteur' => $this->input->post('type_transporteur'),
				'nom_chauffeur' => $this->input->post('nom_chauffeur'),
				'matricule' => $this->input->post('matricule'),
				'tel' => $this->input->post('tel'),
			];

			
			
			$save_agritun_transporteurs = $this->model_agritun_transporteurs->store($save_data);
            

			if ($save_agritun_transporteurs) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_transporteurs;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_transporteurs/edit/' . $save_agritun_transporteurs, 'Edit Agritun Transporteurs'),
						anchor('administrator/agritun_transporteurs', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_transporteurs/edit/' . $save_agritun_transporteurs, 'Edit Agritun Transporteurs')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_transporteurs');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_transporteurs');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Transporteurss
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_transporteurs_update');

		$this->data['agritun_transporteurs'] = $this->model_agritun_transporteurs->find($id);

		$this->template->title('Agritun Transporteurs Update');
		$this->render('backend/standart/administrator/agritun_transporteurs/agritun_transporteurs_update', $this->data);
	}

	/**
	* Update Agritun Transporteurss
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_transporteurs_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('type_transporteur', 'نوع النقل', 'trim|required');
		

		$this->form_validation->set_rules('nom_chauffeur', 'إسم السائق', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('matricule', 'اللوحة المنجمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('tel', 'رقم الهاتف', 'trim|required|max_length[300]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'type_transporteur' => $this->input->post('type_transporteur'),
				'nom_chauffeur' => $this->input->post('nom_chauffeur'),
				'matricule' => $this->input->post('matricule'),
				'tel' => $this->input->post('tel'),
			];


			
			
			$save_agritun_transporteurs = $this->model_agritun_transporteurs->change($id, $save_data);

			if ($save_agritun_transporteurs) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_transporteurs', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_transporteurs');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_transporteurs');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Transporteurss
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_transporteurs_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_transporteurs'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_transporteurs'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Transporteurss
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_transporteurs_view');

		$this->data['agritun_transporteurs'] = $this->model_agritun_transporteurs->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Agritun Transporteurs Detail');
		$this->render('backend/standart/administrator/agritun_transporteurs/agritun_transporteurs_view', $this->data);
	}
	
	/**
	* delete Agritun Transporteurss
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_transporteurs = $this->model_agritun_transporteurs->find($id);

		
		
		return $this->model_agritun_transporteurs->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_transporteurs_export');

		$this->model_agritun_transporteurs->export(
			'agritun_transporteurs', 
			'agritun_transporteurs',
			$this->model_agritun_transporteurs->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_transporteurs_export');

		$this->model_agritun_transporteurs->pdf('agritun_transporteurs', 'agritun_transporteurs');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_transporteurs_export');

		$table = $title = 'agritun_transporteurs';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_transporteurs->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_transporteurs.php */
/* Location: ./application/controllers/administrator/Agritun Transporteurs.php */