<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Demandes Controller
*| --------------------------------------------------------------------------
*| Demandes site
*|
*/
class Demandes extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_demandes');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Demandess
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('demandes_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['demandess'] = $this->model_demandes->get($filter, $field, $this->limit_page, $offset);
		$this->data['demandes_counts'] = $this->model_demandes->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/demandes/index/',
			'total_rows'   => $this->data['demandes_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Demandes List');
		$this->render('backend/standart/administrator/demandes/demandes_list', $this->data);
	}
	
	/**
	* Add new demandess
	*
	*/
	public function add()
	{
		$this->is_allowed('demandes_add');

		$this->template->title('Demandes New');
		$this->render('backend/standart/administrator/demandes/demandes_add', $this->data);
	}

	/**
	* Add New Demandess
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('demandes_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		$this->form_validation->set_rules('ref', 'Ref', 'trim|required');
		

		$this->form_validation->set_rules('date_limite', 'Date Limite', 'trim|required');
		

		$this->form_validation->set_rules('nom_prenom', 'Nom Prenom', 'trim|required');
		

		$this->form_validation->set_rules('tel', 'Tel', 'trim|required');
		

		$this->form_validation->set_rules('panne', 'Panne', 'trim|required');
		

		$this->form_validation->set_rules('op_id', 'Op Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('etat', 'Etat', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('res', 'Res', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('desc', 'Desc', 'trim|required');
		

		$this->form_validation->set_rules('dt_fin', 'Dt Fin', 'trim|required');
		

		$this->form_validation->set_rules('couleur', 'Couleur', 'trim|required');
		

		$this->form_validation->set_rules('prix', 'Prix', 'trim|required');
		

		$this->form_validation->set_rules('atelier', 'Atelier', 'trim|required');
		

		$this->form_validation->set_rules('remarque', 'Remarque', 'trim|required');
		

		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		

		$this->form_validation->set_rules('retour', 'Retour', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('date_re', 'Date Re', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => $this->input->post('date'),
				'ref' => $this->input->post('ref'),
				'date_limite' => $this->input->post('date_limite'),
				'nom_prenom' => $this->input->post('nom_prenom'),
				'tel' => $this->input->post('tel'),
				'panne' => $this->input->post('panne'),
				'op_id' => $this->input->post('op_id'),
				'etat' => $this->input->post('etat'),
				'res' => $this->input->post('res'),
				'desc' => $this->input->post('desc'),
				'dt_fin' => $this->input->post('dt_fin'),
				'couleur' => $this->input->post('couleur'),
				'prix' => $this->input->post('prix'),
				'atelier' => $this->input->post('atelier'),
				'remarque' => $this->input->post('remarque'),
				'description' => $this->input->post('description'),
				'retour' => $this->input->post('retour'),
				'date_re' => $this->input->post('date_re'),
			];

			
			
			$save_demandes = $this->model_demandes->store($save_data);
            

			if ($save_demandes) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_demandes;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/demandes/edit/' . $save_demandes, 'Edit Demandes'),
						anchor('administrator/demandes', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/demandes/edit/' . $save_demandes, 'Edit Demandes')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/demandes');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/demandes');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Demandess
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('demandes_update');

		$this->data['demandes'] = $this->model_demandes->find($id);

		$this->template->title('Demandes Update');
		$this->render('backend/standart/administrator/demandes/demandes_update', $this->data);
	}

	/**
	* Update Demandess
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('demandes_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('date', 'Date', 'trim|required');
		

		$this->form_validation->set_rules('ref', 'Ref', 'trim|required');
		

		$this->form_validation->set_rules('date_limite', 'Date Limite', 'trim|required');
		

		$this->form_validation->set_rules('nom_prenom', 'Nom Prenom', 'trim|required');
		

		$this->form_validation->set_rules('tel', 'Tel', 'trim|required');
		

		$this->form_validation->set_rules('panne', 'Panne', 'trim|required');
		

		$this->form_validation->set_rules('op_id', 'Op Id', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('etat', 'Etat', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('res', 'Res', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('desc', 'Desc', 'trim|required');
		

		$this->form_validation->set_rules('dt_fin', 'Dt Fin', 'trim|required');
		

		$this->form_validation->set_rules('couleur', 'Couleur', 'trim|required');
		

		$this->form_validation->set_rules('prix', 'Prix', 'trim|required');
		

		$this->form_validation->set_rules('atelier', 'Atelier', 'trim|required');
		

		$this->form_validation->set_rules('remarque', 'Remarque', 'trim|required');
		

		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		

		$this->form_validation->set_rules('retour', 'Retour', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('date_re', 'Date Re', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => $this->input->post('date'),
				'ref' => $this->input->post('ref'),
				'date_limite' => $this->input->post('date_limite'),
				'nom_prenom' => $this->input->post('nom_prenom'),
				'tel' => $this->input->post('tel'),
				'panne' => $this->input->post('panne'),
				'op_id' => $this->input->post('op_id'),
				'etat' => $this->input->post('etat'),
				'res' => $this->input->post('res'),
				'desc' => $this->input->post('desc'),
				'dt_fin' => $this->input->post('dt_fin'),
				'couleur' => $this->input->post('couleur'),
				'prix' => $this->input->post('prix'),
				'atelier' => $this->input->post('atelier'),
				'remarque' => $this->input->post('remarque'),
				'description' => $this->input->post('description'),
				'retour' => $this->input->post('retour'),
				'date_re' => $this->input->post('date_re'),
			];


			
			
			$save_demandes = $this->model_demandes->change($id, $save_data);

			if ($save_demandes) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/demandes', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/demandes');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/demandes');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Demandess
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('demandes_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'demandes'), 'success');
        } else {
            set_message(cclang('error_delete', 'demandes'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Demandess
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('demandes_view');

		$this->data['demandes'] = $this->model_demandes->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Demandes Detail');
		$this->render('backend/standart/administrator/demandes/demandes_view', $this->data);
	}
	
	/**
	* delete Demandess
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$demandes = $this->model_demandes->find($id);

		
		
		return $this->model_demandes->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('demandes_export');

		$this->model_demandes->export(
			'demandes', 
			'demandes',
			$this->model_demandes->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('demandes_export');

		$this->model_demandes->pdf('demandes', 'demandes');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('demandes_export');

		$table = $title = 'demandes';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_demandes->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file demandes.php */
/* Location: ./application/controllers/administrator/Demandes.php */