<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_accueil extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_accueil');
	}

	/**
	 * @api {get} /webvue_accueil/all Get all webvue_accueils.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueaccueil 
	 * @apiGroup webvue_accueil
	 * @apiHeader {String} X-Api-Key Webvue accueils unique access-key.
	 * @apiPermission Webvue accueil Cant be Accessed permission name : api_webvue_accueil_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue accueils.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue accueils : id, label, button, img_url, link.
	 * @apiParam {String} [Start=0] Optional start index of Webvue accueils.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue accueils.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_accueil.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue accueil Webvue accueil data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_accueil_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'label', 'button', 'img_url', 'link'];
		$webvue_accueils = $this->model_api_webvue_accueil->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_accueil->count_all($filter, $field);
		$webvue_accueils = array_map(function($row){
						
			return $row;
		}, $webvue_accueils);

		$data['webvue_accueil'] = $webvue_accueils;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue accueil',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_accueil/detail Detail Webvue accueil.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue accueil
	 * @apiGroup webvue_accueil
	 * @apiHeader {String} X-Api-Key Webvue accueils unique access-key.
	 * @apiPermission Webvue accueil Cant be Accessed permission name : api_webvue_accueil_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue accueils.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_accueil.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue accueilNotFound Webvue accueil data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_accueil_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'label', 'button', 'img_url', 'link'];
		$webvue_accueil = $this->model_api_webvue_accueil->find($id, $select_field);

		if (!$webvue_accueil) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_accueil'] = $webvue_accueil;
		if ($data['webvue_accueil']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue accueil',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue accueil not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_accueil/add Add Webvue accueil.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue accueil
	 * @apiGroup webvue_accueil
	 * @apiHeader {String} X-Api-Key Webvue accueils unique access-key.
	 * @apiPermission Webvue accueil Cant be Accessed permission name : api_webvue_accueil_add
	 *
 	 * @apiParam {String} [Id] Optional id of Webvue accueils.  
	 * @apiParam {String} Label Mandatory label of Webvue accueils.  
	 * @apiParam {String} Button Mandatory button of Webvue accueils. Input Button Max Length : 100. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue accueils.  
	 * @apiParam {String} Link Mandatory link of Webvue accueils.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_accueil_add', false);

		$this->form_validation->set_rules('label', 'Label', 'trim|required');
		$this->form_validation->set_rules('button', 'Button', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'id' => $this->input->post('id'),
				'label' => $this->input->post('label'),
				'button' => $this->input->post('button'),
				'img_url' => $this->input->post('img_url'),
				'link' => $this->input->post('link'),
			];
			
			$save_webvue_accueil = $this->model_api_webvue_accueil->store($save_data);

			if ($save_webvue_accueil) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_accueil/update Update Webvue accueil.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue accueil
	 * @apiGroup webvue_accueil
	 * @apiHeader {String} X-Api-Key Webvue accueils unique access-key.
	 * @apiPermission Webvue accueil Cant be Accessed permission name : api_webvue_accueil_update
	 *
	 * @apiParam {String} [Id] Optional id of Webvue accueils.  
	 * @apiParam {String} Label Mandatory label of Webvue accueils.  
	 * @apiParam {String} Button Mandatory button of Webvue accueils. Input Button Max Length : 100. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue accueils.  
	 * @apiParam {String} Link Mandatory link of Webvue accueils.  
	 * @apiParam {Integer} id Mandatory id of Webvue Accueil.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_accueil_update', false);

		
		$this->form_validation->set_rules('label', 'Label', 'trim|required');
		$this->form_validation->set_rules('button', 'Button', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'id' => $this->input->post('id'),
				'label' => $this->input->post('label'),
				'button' => $this->input->post('button'),
				'img_url' => $this->input->post('img_url'),
				'link' => $this->input->post('link'),
			];
			
			$save_webvue_accueil = $this->model_api_webvue_accueil->change($this->post('id'), $save_data);

			if ($save_webvue_accueil) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_accueil/delete Delete Webvue accueil. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue accueil
	 * @apiGroup webvue_accueil
	 * @apiHeader {String} X-Api-Key Webvue accueils unique access-key.
	 	 * @apiPermission Webvue accueil Cant be Accessed permission name : api_webvue_accueil_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue accueils .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_accueil_delete', false);

		$webvue_accueil = $this->model_api_webvue_accueil->find($this->post('id'));

		if (!$webvue_accueil) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue accueil not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_accueil->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue accueil deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue accueil not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue accueil.php */
/* Location: ./application/controllers/api/Webvue accueil.php */