<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_pages extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_pages');
	}

	/**
	 * @api {get} /webvue_pages/all Get all webvue_pagess.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvuepages 
	 * @apiGroup webvue_pages
	 * @apiHeader {String} X-Api-Key Webvue pagess unique access-key.
	 * @apiHeader {String} X-Token Webvue pagess unique token.
	 * @apiPermission Webvue pages Cant be Accessed permission name : api_webvue_pages_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue pagess.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue pagess : id, Subtitle, Title, Content.
	 * @apiParam {String} [Start=0] Optional start index of Webvue pagess.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue pagess.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_pages.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue pages Webvue pages data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_pages_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'Subtitle', 'Title', 'Content'];
		$webvue_pagess = $this->model_api_webvue_pages->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_pages->count_all($filter, $field);
		$webvue_pagess = array_map(function($row){
						
			return $row;
		}, $webvue_pagess);

		$data['webvue_pages'] = $webvue_pagess;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue pages',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_pages/detail Detail Webvue pages.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue pages
	 * @apiGroup webvue_pages
	 * @apiHeader {String} X-Api-Key Webvue pagess unique access-key.
	 * @apiHeader {String} X-Token Webvue pagess unique token.
	 * @apiPermission Webvue pages Cant be Accessed permission name : api_webvue_pages_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue pagess.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_pages.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue pagesNotFound Webvue pages data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_pages_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'Subtitle', 'Title', 'Content'];
		$webvue_pages = $this->model_api_webvue_pages->find($id, $select_field);

		if (!$webvue_pages) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_pages'] = $webvue_pages;
		if ($data['webvue_pages']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue pages',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue pages not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_pages/add Add Webvue pages.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue pages
	 * @apiGroup webvue_pages
	 * @apiHeader {String} X-Api-Key Webvue pagess unique access-key.
	 * @apiHeader {String} X-Token Webvue pagess unique token.
	 * @apiPermission Webvue pages Cant be Accessed permission name : api_webvue_pages_add
	 *
 	 * @apiParam {String} Subtitle Mandatory Subtitle of Webvue pagess. Input Subtitle Max Length : 100. 
	 * @apiParam {String} Title Mandatory Title of Webvue pagess. Input Title Max Length : 300. 
	 * @apiParam {String} Content Mandatory Content of Webvue pagess.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_pages_add');

		$this->form_validation->set_rules('Subtitle', 'Subtitle', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('Title', 'Title', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('Content', 'Content', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'Subtitle' => $this->input->post('Subtitle'),
				'Title' => $this->input->post('Title'),
				'Content' => $this->input->post('Content'),
			];
			
			$save_webvue_pages = $this->model_api_webvue_pages->store($save_data);

			if ($save_webvue_pages) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_pages/update Update Webvue pages.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue pages
	 * @apiGroup webvue_pages
	 * @apiHeader {String} X-Api-Key Webvue pagess unique access-key.
	 * @apiHeader {String} X-Token Webvue pagess unique token.
	 * @apiPermission Webvue pages Cant be Accessed permission name : api_webvue_pages_update
	 *
	 * @apiParam {String} Subtitle Mandatory Subtitle of Webvue pagess. Input Subtitle Max Length : 100. 
	 * @apiParam {String} Title Mandatory Title of Webvue pagess. Input Title Max Length : 300. 
	 * @apiParam {String} Content Mandatory Content of Webvue pagess.  
	 * @apiParam {Integer} id Mandatory id of Webvue Pages.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_pages_update');

		
		$this->form_validation->set_rules('Subtitle', 'Subtitle', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('Title', 'Title', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('Content', 'Content', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'Subtitle' => $this->input->post('Subtitle'),
				'Title' => $this->input->post('Title'),
				'Content' => $this->input->post('Content'),
			];
			
			$save_webvue_pages = $this->model_api_webvue_pages->change($this->post('id'), $save_data);

			if ($save_webvue_pages) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_pages/delete Delete Webvue pages. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue pages
	 * @apiGroup webvue_pages
	 * @apiHeader {String} X-Api-Key Webvue pagess unique access-key.
	 * @apiHeader {String} X-Token Webvue pagess unique token.
	 	 * @apiPermission Webvue pages Cant be Accessed permission name : api_webvue_pages_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue pagess .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_pages_delete');

		$webvue_pages = $this->model_api_webvue_pages->find($this->post('id'));

		if (!$webvue_pages) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue pages not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_pages->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue pages deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue pages not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue pages.php */
/* Location: ./application/controllers/api/Webvue pages.php */