<?php

defined('BASEPATH') OR exit('No direct script access allowed');



use \Firebase\JWT\JWT;



class Webvue_settings extends API

{

	

	public function __construct()

	{

		parent::__construct();

		$this->load->model('model_api_webvue_settings');
left
	}



	/**

	 * @api {get} /webvue_settings/all Get all webvue_settingss.

	 * @apiVersion 0.1.0

	 * @apiName AllWebvuesettings 

	 * @apiGroup webvue_settings

	 * @apiHeader {String} X-Api-Key Webvue settingss unique access-key.

	 * @apiPermission Webvue settings Cant be Accessed permission name : api_webvue_settings_all

	 *

	 * @apiParam {String} [Filter=null] Optional filter of Webvue settingss.

	 * @apiParam {String} [Field="All Field"] Optional field of Webvue settingss : id, adresse, numeros, emails, horaires, logo_url, footer_description, favicon, copyright, fb, twitter, instagram, linkedin.

	 * @apiParam {String} [Start=0] Optional start index of Webvue settingss.

	 * @apiParam {String} [Limit=10] Optional limit data of Webvue settingss.left

	 *

	 *

	 * @apiSuccess {Boolean} Status status response api.

	 * @apiSuccess {String} Message message response api.

	 * @apiSuccess {Array} Data data of webvue_settings.

	 *

	 * @apiSuccessExample Success-Response:

	 *     HTTP/1.1 200 OK

	 *

	 * @apiError NoDataWebvue settings Webvue settings data is nothing.

	 *

	 * @apiErrorExample Error-Response:

	 *     HTTP/1.1 403 Not Acceptable

	 *

	 */

	public function all_get()

	{

		$this->is_allowed('api_webvue_settings_all', false);



		$filter = $this->get('filter');

		$field = $this->get('field');

		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;

		$start = $this->get('start');


left
		$select_field = ['id', 'adresse', 'numeros', 'emails', 'horaires', 'logo_url', 'footer_description', 'favicon', 'copyright', 'fb', 'twitter', 'instagram', 'linkedin'];

		$webvue_settingss = $this->model_api_webvue_settings->get($filter, $field, $limit, $start, $select_field);

		$total = $this->model_api_webvue_settings->count_all($filter, $field);

		$webvue_settingss = array_map(function($row){

						

			return $row;

		}, $webvue_settingss);



		$data['webvue_settings'] = $webvue_settingss;

				

		$this->response([

			'status' 	=> true,

			'message' 	=> 'Data Webvue settings',

			'data'	 	=> $data,

			'total' 	=> $total,

		], API::HTTP_OK);

	}



		/**

	 * @api {get} /webvue_settings/detail Detail Webvue settings.

	 * @apiVersion 0.1.0

	 * @apiName DetailWebvue sleftgsleftleft

	 * @apiGroup webvue_settings

	 * @apiHeader {String} X-Api-Key Webvue settingss unique access-key.

	 * @apiPermission Webvue settings Cant be Accessed permission name : api_webvue_settings_detail

	 *

	 * @apiParam {Integer} Id Mandatory id of Webvue settingss.

	 *

	 * @apiSuccess {Boolean} Status status response api.

	 * @apiSuccess {String} Message message response api.

	 * @apiSuccess {Array} Data data of webvue_settings.

	 *

	 * @apiSuccessExample Success-Response:

	 *     HTTP/1.1 200 OK

	 *

	 * @apiError Webvue settingsNotFound Webvue settings data is not found.
leftleft
	 *

	 * @apiErrorExample Error-Response:

	 *     HTTP/1.1 403 Not Acceptable

	 *

	 */

	public function detail_get()

	{

		$this->is_allowed('api_webvue_settings_detail', false);
leftleft


		$this->requiredInput(['id']);



		$id = $this->get('id');



		$select_field = ['id', 'adresse', 'numeros', 'emails', 'horaires', 'logo_url', 'footer_description', 'favicon', 'copyright', 'fb', 'twitter', 'instagram', 'linkedin'];

		$webvue_settings = $this->model_api_webvue_settings->find($id, $select_field);



		if (!$webvue_settings) {

			$this->response([

					'status' 	=> false,

					'message' 	=> 'Blog not found'

				], API::HTTP_NOT_FOUND);

		}



					

		$data['webvue_settings'] = $webvue_settings;

		if ($data['webvue_settings']) {

			

			$this->response([

				'status' 	=> true,

				'message' 	=> 'Detail Webvue settings',

				'data'	 	=> $data
leftleftleft
			], API::HTTP_OK);

		} else {

			$this->response([

				'status' 	=> false,

				'message' 	=> 'Webvue settings not found'

			], API::HTTP_NOT_ACCEPTABLE);

		}

	}



	

	/**

	 * @api {post} /webvue_settings/add Add Webvue settings.

	 * @apiVersion 0.1.0

	 * @apiName AddWebvue settings

	 * @apiGroup webvue_settings

	 * @apiHeader {String} X-Api-Key Webvue leftngss unileftccess-key.

	 * @apiPermission Webvue settings Cant be Accessed permission name : api_webvue_settings_add

	 *

 	 * @apiParam {String} Adresse Mandatory adresse of Webvue settingss.  

	 * @apiParam {String} Numeros Mandatory numeros of Webvue settingss.  

	 * @apiParam {String} Emails Mandatory emails of Webvue settingss.  

	 * @apiParam {String} Horaires Mandatory horaires of Webvue settingss.  

	 * @apiParam {String} Logo_url Mandatory logo_url of Webvue settingss.  

	 * @apiPleft{String} Footer_description Mleftory footer_description of Webvue settingss.  

	 * @apiParam {String} Favicon Mandatory favicon of Webvue settingss.  

	 * @apiParam {String} Copyright Mandatory copyright of Webvue settingss. Input Copyright Max Length : 10. 

	 * @apiParam {String} Fb Mandatory fb of Webvue settingss. Input Fb Max Length : 200. 

	 * @apiParam {String} Twitter Mandatory twitter of Webvue settingss. Input Twitter Max Length : 200. 

	 * @apiParam {String} Instagram Mandatory instagram of Webvue settingss. Input Instagram Max Length : 200. 

	 * @apiParam {String} Linkedin Mandatory linkedin of Webvue settingss. Input Linkedin Max Length : 200. 

	 *

	 * @apiSuccess {Boolean} Status status response api.

	 * @apiSuccess {String} Message message response api.

	 *

	 * @apiSuccessExample Success-Response:

	 *     HTTP/1.1 200 OK

	 *

	 * @apiError ValidationError Error validation.

	 *

	 * @apiErrorExample Error-Response:

	 *     HTTP/1.1 403 Not Acceptable

	 *

	 */

	public function add_post()

	{

		$this->is_allowed('api_webvue_settings_add', false);



		$this->form_validation->set_rules('adresse', 'Adresse', 'trim|required');

		$this->form_validation->set_rules('numeros', 'Numeros', 'trim|required');

		$this->form_validation->set_rules('emails', 'Emails', 'trim|required');

		$this->form_validation->set_rules('horaires', 'Horaires', 'trim|required');

		$this->form_validation->set_rules('logo_url', 'Logo Url', 'trim|required');

		$this->form_validation->set_rules('footer_description', 'Footer Description', 'trim|required');

		$this->form_validation->set_rules('favicon', 'Favicon', 'trim|required');

		$this->form_validation->set_rules('copyright', 'Copyright', 'trim|required|max_length[10]');

		$this->form_validation->set_rules('fb', 'Fb', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('twitter', 'Twitter', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('instagram', 'Instagram', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('linkedin', 'Linkedin', 'trim|required|max_length[200]');

		

		if ($this->form_validation->run()) {



			$save_data = [

				'adresse' => $this->input->post('adresse'),

				'numeros' => $this->input->post('numeros'),

				'emails' => $this->input->post('emails'),

				'horaires' => $this->input->post('horaires'),

				'logo_url' => $this->input->post('logo_url'),

				'footer_description' => $this->input->post('footer_description'),

				'favicon' => $this->input->post('favicon'),

				'copyright' => $this->input->post('copyright'),

				'fb' => $this->input->post('fb'),

				'twitter' => $this->input->post('twitter'),

				'instagram' => $this->input->post('instagram'),

				'linkedin' => $this->input->post('linkedin'),

			];

			

			$save_webvue_settings = $this->model_api_webvue_settings->store($save_data);



			if ($save_webvue_settings) {

				$this->response([

					'status' 	=> true,

					'message' 	=> 'Your data has been successfully stored into the database'

				], API::HTTP_OK);



			} else {

				$this->response([

					'status' 	=> false,

					'message' 	=> cclang('data_not_change')

				], API::HTTP_NOT_ACCEPTABLE);

			}



		} else {

			$this->response([

				'status' 	=> false,

				'message' 	=> 'Validation Errors.',

				'errors' 	=> $this->form_validation->error_array()

			], API::HTTP_NOT_ACCEPTABLE);

		}

	}



	/**

	 * @api {post} /webvue_settings/update Update Webvue settings.

	 * @apiVersion 0.1.0

	 * @apiName UpdateWebvue settings

	 * @apiGroup webvue_settings

	 * @apiHeader {String} X-Api-Key Webvue settingss unique access-key.

	 * @apiPermission Webvue settings Cant be Accessed permission name : api_webvue_settings_update

	 *

	 * @apiParam {String} Adresse Mandatory adresse of Webvue settingss.  

	 * @apiParam {String} Numeros Mandatory numeros of Webvue settingss.  

	 * @apiParam {String} Emails Mandatory emails of Webvue settingss.  

	 * @apiParam {String} Horaires Mandatory horaires of Webvue settingss.  

	 * @apiParam {String} Logo_url Mandatory logo_url of Webvue settingss.  

	 * @apiParam {String} Footer_description Mandatory footer_description of Webvue settingss.  

	 * @apiParam {String} Favicon Mandatory favicon of Webvue settingss.  

	 * @apiParam {String} Copyright Mandatory copyright of Webvue settingss. Input Copyright Max Length : 10. 

	 * @apiParam {String} Fb Mandatory fb of Webvue settingss. Input Fb Max Length : 200. 

	 * @apiParam {String} Twitter Mandatory twitter of Webvue settingss. Input Twitter Max Length : 200. 

	 * @apiParam {String} Instagram Mandatory instagram of Webvue settingss. Input Instagram Max Length : 200. 

	 * @apiParam {String} Linkedin Mandatory linkedin of Webvue settingss. Input Linkedin Max Length : 200. 

	 * @apiParam {Integer} id Mandatory id of Webvue Settings.

	 *

	 * @apiSuccess {Boolean} Status status response api.

	 * @apiSuccess {String} Message message response api.

	 *

	 * @apiSuccessExample Success-Response:

	 *     HTTP/1.1 200 OK

	 *

	 * @apiError ValidationError Error validation.

	 *

	 * @apiErrorExample Error-Response:

	 *     HTTP/1.1 403 Not Acceptable

	 *

	 */

	public function update_post()

	{

		$this->is_allowed('api_webvue_settings_update', false);



		

		$this->form_validation->set_rules('adresse', 'Adresse', 'trim|required');

		$this->form_validation->set_rules('numeros', 'Numeros', 'trim|required');

		$this->form_validation->set_rules('emails', 'Emails', 'trim|required');

		$this->form_validation->set_rules('horaires', 'Horaires', 'trim|required');

		$this->form_validation->set_rules('logo_url', 'Logo Url', 'trim|required');

		$this->form_validation->set_rules('footer_description', 'Footer Description', 'trim|required');

		$this->form_validation->set_rules('favicon', 'Favicon', 'trim|required');

		$this->form_validation->set_rules('copyright', 'Copyright', 'trim|required|max_length[10]');

		$this->form_validation->set_rules('fb', 'Fb', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('twitter', 'Twitter', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('instagram', 'Instagram', 'trim|required|max_length[200]');

		$this->form_validation->set_rules('linkedin', 'Linkedin', 'trim|required|max_length[200]');

		

		if ($this->form_validation->run()) {



			$save_data = [

				'adresse' => $this->input->post('adresse'),

				'numeros' => $this->input->post('numeros'),

				'emails' => $this->input->post('emails'),

				'horaires' => $this->input->post('horaires'),

				'logo_url' => $this->input->post('logo_url'),

				'footer_description' => $this->input->post('footer_description'),

				'favicon' => $this->input->post('favicon'),

				'copyright' => $this->input->post('copyright'),

				'fb' => $this->input->post('fb'),

				'twitter' => $this->input->post('twitter'),

				'instagram' => $this->input->post('instagram'),

				'linkedin' => $this->input->post('linkedin'),

			];

			

			$save_webvue_settings = $this->model_api_webvue_settings->change($this->post('id'), $save_data);



			if ($save_webvue_settings) {

				$this->response([

					'status' 	=> true,

					'message' 	=> 'Your data has been successfully updated into the database'

				], API::HTTP_OK);



			} else {

				$this->response([

					'status' 	=> false,

					'message' 	=> cclang('data_not_change')

				], API::HTTP_NOT_ACCEPTABLE);

			}



		} else {

			$this->response([

				'status' 	=> false,

				'message' 	=> 'Validation Errors.',

				'errors' 	=> $this->form_validation->error_array()

			], API::HTTP_NOT_ACCEPTABLE);

		}

	}

	

	/**

	 * @api {post} /webvue_settings/delete Delete Webvue settings. 

	 * @apiVersion 0.1.0

	 * @apiName DeleteWebvue settings

	 * @apiGroup webvue_settings

	 * @apiHeader {String} X-Api-Key Webvue settingss unique access-key.

	 	 * @apiPermission Webvue settings Cant be Accessed permission name : api_webvue_settings_delete

	 *

	 * @apiParam {Integer} Id Mandatory id of Webvue settingss .

	 *

	 * @apiSuccess {Boolean} Status status response api.

	 * @apiSuccess {String} Message message response api.

	 *

	 * @apiSuccessExample Success-Response:

	 *     HTTP/1.1 200 OK

	 *

	 * @apiError ValidationError Error validation.

	 *

	 * @apiErrorExample Error-Response:

	 *     HTTP/1.1 403 Not Acceptable

	 *

	 */

	public function delete_post()

	{

		$this->is_allowed('api_webvue_settings_delete', false);



		$webvue_settings = $this->model_api_webvue_settings->find($this->post('id'));



		if (!$webvue_settings) {

			$this->response([

				'status' 	=> false,

				'message' 	=> 'Webvue settings not found'

			], API::HTTP_NOT_ACCEPTABLE);

		} else {

			$delete = $this->model_api_webvue_settings->remove($this->post('id'));



			}

		

		if ($delete) {

			$this->response([

				'status' 	=> true,

				'message' 	=> 'Webvue settings deleted',

			], API::HTTP_OK);

		} else {

			$this->response([

				'status' 	=> false,

				'message' 	=> 'Webvue settings not delete'

			], API::HTTP_NOT_ACCEPTABLE);

		}

	}

	

}



/* End of file Webvue settings.php */

/* Location: ./application/controllers/api/Webvue settings.php */