<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_works extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_works');
	}

	/**
	 * @api {get} /webvue_works/all Get all webvue_workss.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueworks 
	 * @apiGroup webvue_works
	 * @apiHeader {String} X-Api-Key Webvue workss unique access-key.
	 * @apiPermission Webvue works Cant be Accessed permission name : api_webvue_works_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue workss.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue workss : id, title, cat_id, img_url, link, description.
	 * @apiParam {String} [Start=0] Optional start index of Webvue workss.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue workss.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_works.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue works Webvue works data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_works_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'title', 'cat_id', 'img_url', 'link', 'description'];
		$webvue_workss = $this->model_api_webvue_works->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_works->count_all($filter, $field);
		$webvue_workss = array_map(function($row){
						
			return $row;
		}, $webvue_workss);

		$data['webvue_works'] = $webvue_workss;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue works',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_works/detail Detail Webvue works.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue works
	 * @apiGroup webvue_works
	 * @apiHeader {String} X-Api-Key Webvue workss unique access-key.
	 * @apiPermission Webvue works Cant be Accessed permission name : api_webvue_works_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue workss.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_works.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue worksNotFound Webvue works data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_works_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'title', 'cat_id', 'img_url', 'link', 'description'];
		$webvue_works = $this->model_api_webvue_works->find($id, $select_field);

		if (!$webvue_works) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_works'] = $webvue_works;
		if ($data['webvue_works']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue works',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_works/add Add Webvue works.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue works
	 * @apiGroup webvue_works
	 * @apiHeader {String} X-Api-Key Webvue workss unique access-key.
	 * @apiPermission Webvue works Cant be Accessed permission name : api_webvue_works_add
	 *
 	 * @apiParam {String} Title Mandatory title of Webvue workss. Input Title Max Length : 400. 
	 * @apiParam {String} Cat_id Mandatory cat_id of Webvue workss. Input Cat Id Max Length : 40. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue workss.  
	 * @apiParam {String} Link Mandatory link of Webvue workss.  
	 * @apiParam {String} Description Mandatory description of Webvue workss.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_works_add', false);

		$this->form_validation->set_rules('title', 'Title', 'trim|required|max_length[400]');
		$this->form_validation->set_rules('cat_id', 'Cat Id', 'trim|required|max_length[40]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'title' => $this->input->post('title'),
				'cat_id' => $this->input->post('cat_id'),
				'img_url' => $this->input->post('img_url'),
				'link' => $this->input->post('link'),
				'description' => $this->input->post('description'),
			];
			
			$save_webvue_works = $this->model_api_webvue_works->store($save_data);

			if ($save_webvue_works) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_works/update Update Webvue works.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue works
	 * @apiGroup webvue_works
	 * @apiHeader {String} X-Api-Key Webvue workss unique access-key.
	 * @apiPermission Webvue works Cant be Accessed permission name : api_webvue_works_update
	 *
	 * @apiParam {String} Title Mandatory title of Webvue workss. Input Title Max Length : 400. 
	 * @apiParam {String} Cat_id Mandatory cat_id of Webvue workss. Input Cat Id Max Length : 40. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue workss.  
	 * @apiParam {String} Link Mandatory link of Webvue workss.  
	 * @apiParam {String} Description Mandatory description of Webvue workss.  
	 * @apiParam {Integer} id Mandatory id of Webvue Works.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_works_update', false);

		
		$this->form_validation->set_rules('title', 'Title', 'trim|required|max_length[400]');
		$this->form_validation->set_rules('cat_id', 'Cat Id', 'trim|required|max_length[40]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'title' => $this->input->post('title'),
				'cat_id' => $this->input->post('cat_id'),
				'img_url' => $this->input->post('img_url'),
				'link' => $this->input->post('link'),
				'description' => $this->input->post('description'),
			];
			
			$save_webvue_works = $this->model_api_webvue_works->change($this->post('id'), $save_data);

			if ($save_webvue_works) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_works/delete Delete Webvue works. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue works
	 * @apiGroup webvue_works
	 * @apiHeader {String} X-Api-Key Webvue workss unique access-key.
	 	 * @apiPermission Webvue works Cant be Accessed permission name : api_webvue_works_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue workss .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_works_delete', false);

		$webvue_works = $this->model_api_webvue_works->find($this->post('id'));

		if (!$webvue_works) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_works->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue works deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue works.php */
/* Location: ./application/controllers/api/Webvue works.php */