<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_works_cat extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_works_cat');
	}

	/**
	 * @api {get} /webvue_works_cat/all Get all webvue_works_cats.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueworkscat 
	 * @apiGroup webvue_works_cat
	 * @apiHeader {String} X-Api-Key Webvue works cats unique access-key.
	 * @apiPermission Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue works cats.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue works cats : id, name.
	 * @apiParam {String} [Start=0] Optional start index of Webvue works cats.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue works cats.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_works_cat.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue works cat Webvue works cat data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_works_cat_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name'];
		$webvue_works_cats = $this->model_api_webvue_works_cat->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_works_cat->count_all($filter, $field);
		$webvue_works_cats = array_map(function($row){
						
			return $row;
		}, $webvue_works_cats);

		$data['webvue_works_cat'] = $webvue_works_cats;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue works cat',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_works_cat/detail Detail Webvue works cat.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue works cat
	 * @apiGroup webvue_works_cat
	 * @apiHeader {String} X-Api-Key Webvue works cats unique access-key.
	 * @apiPermission Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue works cats.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_works_cat.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue works catNotFound Webvue works cat data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_works_cat_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name'];
		$webvue_works_cat = $this->model_api_webvue_works_cat->find($id, $select_field);

		if (!$webvue_works_cat) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_works_cat'] = $webvue_works_cat;
		if ($data['webvue_works_cat']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue works cat',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works cat not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_works_cat/add Add Webvue works cat.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue works cat
	 * @apiGroup webvue_works_cat
	 * @apiHeader {String} X-Api-Key Webvue works cats unique access-key.
	 * @apiPermission Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_add
	 *
 	 * @apiParam {String} Name Mandatory name of Webvue works cats. Input Name Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_works_cat_add', false);

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
			];
			
			$save_webvue_works_cat = $this->model_api_webvue_works_cat->store($save_data);

			if ($save_webvue_works_cat) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_works_cat/update Update Webvue works cat.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue works cat
	 * @apiGroup webvue_works_cat
	 * @apiHeader {String} X-Api-Key Webvue works cats unique access-key.
	 * @apiPermission Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_update
	 *
	 * @apiParam {String} Name Mandatory name of Webvue works cats. Input Name Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Webvue Works Cat.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_works_cat_update', false);

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
			];
			
			$save_webvue_works_cat = $this->model_api_webvue_works_cat->change($this->post('id'), $save_data);

			if ($save_webvue_works_cat) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_works_cat/delete Delete Webvue works cat. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue works cat
	 * @apiGroup webvue_works_cat
	 * @apiHeader {String} X-Api-Key Webvue works cats unique access-key.
	 	 * @apiPermission Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue works cats .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_works_cat_delete', false);

		$webvue_works_cat = $this->model_api_webvue_works_cat->find($this->post('id'));

		if (!$webvue_works_cat) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works cat not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_works_cat->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue works cat deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue works cat not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue works cat.php */
/* Location: ./application/controllers/api/Webvue works cat.php */